<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "cag_report".
 *
 * @property integer $id
 * @property integer $type
 * @property integer $accepted
 * @property string $filepath
 * @property string $ext
 * @property string $description
 * @property integer $financial_year_id
 * @property integer $created_at
 * @property integer $created_by
 */
class CagReport extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'cag_report';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['type', 'filepath', 'ext', 'financial_year_id'], 'required'],
            [['type', 'accepted', 'financial_year_id', 'created_at', 'created_by'], 'integer'],
            [['description'], 'string'],
            [['filepath'], 'string', 'max' => 255],
            [['ext'], 'string', 'max' => 5],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'type' => 'Type of Report',
            'accepted' => 'Accepted',
            'filepath' => 'Filepath',
            'ext' => 'Ext',
            'description' => 'Description',
            'financial_year_id' => 'Financial Year',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
        ];
    }
     public function beforeSave($insert) {
          if($this->isNewRecord){
           $this->created_at = time();
           $this->created_by = Yii::$app->user->id;
          }
         
          
        return parent::beforeSave($insert);
    }
    public function getFinancialYear()
    {
        return $this->hasOne(FinancialYear::className(), ['id' => 'financial_year_id']);
    }
}
