<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "issue_status_changes".
 *
 * @property integer $id
 * @property integer $plan_id
 * @property integer $status_to
 * @property integer $created_at
 * @property integer $created_by
 * @property string $remark
 */
class IssueStatusChanges extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'issue_status_changes';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['plan_id', 'status_to', 'created_at', 'created_by'], 'required'],
            [['plan_id', 'status_to', 'created_at', 'created_by'], 'integer'],
            [['remark'], 'string'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'plan_id' => 'Plan ID',
            'status_to' => 'Status To',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'remark' => 'Remark',
        ];
    }
}
