<?php

namespace common\models;

use Yii;
use yii\base\Model;

/**
 * ContactForm is the model behind the contact form.
 */
class PermissionForm extends Model
{
    public $category_id;
    public $items;


    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            // name, email, subject and body are required
            [['items'], 'safe'],
            [['category_id'], 'required']
           

        ];
    }

    /**
     * @return array customized attribute labels
     */
    public function attributeLabels()
    {
        return [
            'items' => Yii::t('frontend', 'Permissions'),
             'category_id' => Yii::t('frontend', 'Category'),
           
        ];
    }
    
      public static function getSelected($id)
        {
           $array = [];
           $items = RbacAuthItemChild::findAll(['parent'=>$id]);
             
           if($items):
               foreach($items as $item):
               $array[] = $item->child;
               endforeach;
           endif;
           return $array;
        }

}
