<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "reporting_upload".
 *
 * @property integer $id
 * @property string $filepath
 * @property string $description
 * @property integer $reporting_detail_id
 * @property string $ext
 * @property integer $created_at
 * @property integer $created_by
 *
 * @property ReportingDetail $reportingDetail
 */
class ReportingUpload extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'reporting_upload';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['filepath', 'reporting_detail_id', 'created_at', 'created_by'], 'required'],
            [['description'], 'string'],
            [['reporting_detail_id', 'created_at', 'created_by'], 'integer'],
            [['filepath'], 'string', 'max' => 255],
            [['ext'], 'string', 'max' => 45],
            [['reporting_detail_id'], 'exist', 'skipOnError' => true, 'targetClass' => ReportingDetail::className(), 'targetAttribute' => ['reporting_detail_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'filepath' => 'Filepath',
            'description' => 'Description',
            'reporting_detail_id' => 'Reporting Detail ID',
            'ext' => 'Ext',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getReportingDetail()
    {
        return $this->hasOne(ReportingDetail::className(), ['id' => 'reporting_detail_id']);
    }
}
