<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "review_feedback".
 *
 * @property integer $id
 * @property string $filename
 * @property integer $vote_id
 * @property integer $financial_year_id
 * @property integer $quarter_id
 * @property string $name
 * @property integer $created_at
 * @property integer $created_by
 * @property integer $published
 */
class ReviewFeedback extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'review_feedback';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['filename', 'vote_id', 'financial_year_id'], 'required'],
            [['vote_id', 'financial_year_id', 'quarter_id', 'created_at', 'created_by', 'published'], 'integer'],
            [['filename', 'name'], 'string', 'max' => 255],
        ];
    }
     public function behaviors()
    {
        return [
            'bedezign\yii2\audit\AuditTrailBehavior'
        ];
    }
    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'filename' => 'Filename',
            'vote_id' => 'Vote',
            'financial_year_id' => 'Financial Year',
            'quarter_id' => 'Quarter',
            'name' => 'Name',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
            'published' => 'Published',
        ];
    }
    public function getFinancialYear()
    {
        return $this->hasOne(FinancialYear::className(), ['id' => 'financial_year_id']);
    }
    public function getVote()
    {
        return $this->hasOne(Vote::className(), ['id' => 'vote_id']);
    }
     public function getQuarter()
    {
        return $this->hasOne(Quarter::className(), ['id' => 'quarter_id']);
    }
         public function beforeSave($insert) {
          if($this->isNewRecord){
           $this->created_at = time();
           $this->created_by = Yii::$app->user->id;
          }
        
        return parent::beforeSave($insert);
    }
    public static function getAvailable(){
      return self::find()
    ->andWhere(['=', 'published', 1])
              ->all();
   }
}
