<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Auditor as AuditorModel;
use common\models\User;

/**
 * Auditor represents the model behind the search form about `common\models\Auditor`.
 */
class Auditor extends AuditorModel {

    public $fullname;

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['id', 'vote_id', 'gender', 'data_of_birth', 'date_of_appointment'], 'integer'],
            [['professional', 'first_name', 'middle_name', 'last_name', 'title_position', 'fullname', 'phone_number', 'email', 'check_no', 'highest_qualification'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios() {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function searchHq($params) {
        $query = AuditorModel::find();
        $query->joinWith('user');
        $query->andWhere([
            'user.type' => User::TYPE_HQ_OFFICER,
        ]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        $query->orderBy('first_name ASC');
        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'vote_id' => $this->vote_id,
            'gender' => $this->gender,
            'data_of_birth' => $this->data_of_birth,
            'date_of_appointment' => $this->date_of_appointment,
        ]);
        $query->andFilterWhere(['OR', ['first_name' => $this->fullname], ['middle_name' => $this->fullname, 'last_name' => $this->fullname]])
                ->andFilterWhere(['like', 'title_position', $this->title_position])
                ->andFilterWhere(['like', 'phone_number', $this->phone_number])
                ->andFilterWhere(['like', 'email', $this->email])
                ->andFilterWhere(['like', 'check_no', $this->check_no])
                ->andFilterWhere(['like', 'highest_qualification', $this->highest_qualification])
                ->andFilterWhere(['like', 'professional', $this->professional]);

        return $dataProvider;
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = AuditorModel::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        $query->orderBy('first_name ASC');
        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'vote_id' => $this->vote_id,
            'gender' => $this->gender,
            'data_of_birth' => $this->data_of_birth,
            'date_of_appointment' => $this->date_of_appointment,
        ]);

        $query->andFilterWhere(['OR', ['first_name' => $this->fullname], ['middle_name' => $this->fullname, 'last_name' => $this->fullname]])
                ->andFilterWhere(['like', 'title_position', $this->title_position])
                ->andFilterWhere(['like', 'phone_number', $this->phone_number])
                ->andFilterWhere(['like', 'email', $this->email])
                ->andFilterWhere(['like', 'check_no', $this->check_no])
                ->andFilterWhere(['like', 'highest_qualification', $this->highest_qualification])
                ->andFilterWhere(['like', 'professional', $this->professional]);

        return $dataProvider;
    }

}
