<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\CagReport as CagReportModel;
use common\components\Globals;
use common\models\User;

/**
 * Plan represents the model behind the search form about `common\models\Plan`.
 */
class CagReport extends CagReportModel
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
           [['type', 'filepath', 'ext', 'financial_year_id'], 'required'],
            [['vote_id', 'type','accepted', 'financial_year_id', 'created_at', 'created_by'], 'integer'],
            [['description'], 'string'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
         
        $query = CagReportModel::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

       /** if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        } **/

        $query->andFilterWhere([
            'id' => $this->id,          
            'financial_year_id' => $this->financial_year_id,
            'type' => $this->type,
            
        ]);
        
       
        $query->andFilterWhere(['like', 'description', $this->description])
           
            ->andFilterWhere(['like', 'accepted', $this->accepted]);

        return $dataProvider;
    }
}
