<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\CommitteeMember as CommitteeMemberModel;
use common\models\User;

/**
 * CommitteeMember represents the model behind the search form about `common\models\CommitteeMember`.
 */
class CommitteeMember extends CommitteeMemberModel
{
    public $fullname;
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'vote_id', 'gender', 'appointment_end_at', 'appointment_start_at'], 'integer'],
            [['first_name', 'middle_name', 'last_name', 'title_position', 'fullname','phone_number', 'email','highest_qualification'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

      /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function searchHq($params)
    {
        $query = CommitteeMemberModel::find();
        $query->joinWith('user');
        $query->andWhere([
            'user.type' => User::TYPE_HQ_OFFICER,
            ]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
     $query->orderBy('first_name ASC');
        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'vote_id' => $this->vote_id,
            'gender' => $this->gender
        ]);
        $query->orFilterWhere(['like', 'first_name', $this->fullname]);
        $query->orFilterWhere(['like', 'middle_name', $this->fullname]);
        $query->orFilterWhere(['like', 'last_name', $this->fullname])
            
            ->andFilterWhere(['like', 'title_position', $this->title_position])
            ->andFilterWhere(['like', 'phone_number', $this->phone_number])
        
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'highest_qualification', $this->highest_qualification]);

        return $dataProvider;
    }
    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = CommitteeMemberModel::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
     $query->orderBy('first_name ASC');
        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'vote_id' => $this->vote_id,
            'gender' => $this->gender,
        ]);
        $query->orFilterWhere(['like', 'first_name', $this->fullname]);
        $query->orFilterWhere(['like', 'middle_name', $this->fullname]);
        $query->orFilterWhere(['like', 'last_name', $this->fullname])
            
            ->andFilterWhere(['like', 'title_position', $this->title_position])
            ->andFilterWhere(['like', 'phone_number', $this->phone_number])
        
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'highest_qualification', $this->highest_qualification]);

        return $dataProvider;
    }
}
