<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\VoteReport as IagReportModel;
use common\components\Globals;
use common\models\User;

/**
 * Plan represents the model behind the search form about `common\models\Plan`.
 */
class IagReport extends IagReportModel
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
           [['vote_id', 'type', 'filepath', 'ext', 'financial_year_id'], 'required'],
            [['vote_id', 'type','approved', 'financial_year_id', 'created_at', 'created_by', 'quarter_id'], 'integer'],
            [['description'], 'string'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params,$source,$active)
    {
         
        $query = IagReportModel::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
$query->orderBy('id DESC');
        $this->load($params);

       /** if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        } **/
        $query->andWhere('deleted=0');
        $query->andFilterWhere([
            'id' => $this->id,          
            'vote_id' => $this->vote_id,
            'quarter_id' => $this->quarter_id,
            'financial_year_id' => $this->financial_year_id,
            'type' => $this->type,
            
        ]);
        //check for IA officer
        if(User::isIAOfficer()){
            if(Globals::myVote())
                $vote_id = Globals::myVote()->id;
            else
                $vote_id = null;
             $query->andFilterWhere([
           
            'vote_id' => $vote_id,
            
        ]);
            
        }
       
        $query->andFilterWhere(['like', 'description', $this->description])
           
            ->andFilterWhere(['like', 'approved', $this->approved]);

        return $dataProvider;
    }
       /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function searchReport($params)
    {
         
        $query = IagReportModel::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
$query->orderBy('id DESC');
        $this->load($params);

       /** if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        } **/
       $query->andWhere('deleted=0');
        $query->andFilterWhere([
            'id' => $this->id,          
            'vote_id' => $this->vote_id,
            'quarter_id' => $this->quarter_id,
            'financial_year_id' => $this->financial_year_id,
            'type' => $this->type,
            
        ]);
        
       
        $query->andFilterWhere(['like', 'description', $this->description])
           
            ->andFilterWhere(['like', 'approved', $this->approved]);

        return $dataProvider;
    }
      /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function searchNotReport($params)
    {
         
        $query = IagReportModel::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
$query->orderBy('id DESC');
        $this->load($params);

       /** if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        } **/
       $query->andWhere('deleted=0');
        $query->andFilterWhere([
            'id' => $this->id,          
            'vote_id' => $this->vote_id,
            'quarter_id' => $this->quarter_id,
            'financial_year_id' => $this->financial_year_id,
            'type' => $this->type,
            
        ]);
        
       
        $query->andFilterWhere(['like', 'description', $this->description])
           
            ->andFilterWhere(['like', 'approved', $this->approved]);

        return $dataProvider;
    }
}
