<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\IssueReview as IssueReviewModel;
use common\components\Globals;
use common\models\User;

/**
 * Plan represents the model behind the search form about `common\models\Plan`.
 */
class IssueReview extends IssueReviewModel
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'vote_id','plan_id', 'created_at', 'created_by', 'updated_at', 'updated_by'], 'integer'],
            [['vote_id', 'status'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params,$active=null)
    {
       
        $query = IssueReviewModel::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
              'sort' => [
        'defaultOrder' => [
            'created_at' => SORT_DESC,
             
        ]
    ],
        ]);
      

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }
        $query->orderBy('id DESC');
        $daysago = time() - (30*24*3600);
        if($active==2):
             $query->andFilterWhere(['<', 'created_at', $daysago]);;
        endif;
        $daysago = time() - (30*24*3600*2);
        if($active==3):
             $query->andFilterWhere(['<', 'created_at', $daysago]);;
        endif;

        $query->andFilterWhere([
            'id' => $this->id,
            'vote_id' => $this->vote_id,
            
            'created_at' => $this->created_at,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_by' => $this->updated_by,
        ]);
        //check for IA officer
        if(User::isIAOfficer()){
            if(Globals::myVote())
                $vote_id = Globals::myVote()->id;
            else
                $vote_id = null;
             $query->andFilterWhere([
           
            'vote_id' => $vote_id,
            
        ]);
            
        }
      

        return $dataProvider;
    }
}
