<?php

namespace common\models\search;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\ReportingDetail;

/**
 * ReportDetail represents the model behind the search form about `common\models\ReportingDetail`.
 */
class ReportDetail extends ReportingDetail
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'financial_year_id', 'vote_id', 'quarter_id', 'source_id', 'submitted', 'confirmed'], 'integer'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ReportingDetail::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'financial_year_id' => $this->financial_year_id,
            'vote_id' => $this->vote_id,
            'quarter_id' => $this->quarter_id,
            'source_id' => $this->source_id,
            'submitted' => $this->submitted,
            'confirmed' => $this->confirmed,
        ]);

        return $dataProvider;
    }
}
