<?php

namespace frontend\controllers;

use Yii;
use common\models\Plan;
use common\models\search\Plan as PlanSearch;
use common\models\search\IagReport as IagReportSearch;
use common\models\search\IssueReview as IssueReviewSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use \yii\web\Response;
use yii\helpers\Html;
use frontend\models\VoteForm;
use common\models\Source;
use common\models\ActionTaken;
use common\models\RemedialAction;
use common\models\AuditComment;
use common\models\ManagementResponse;
use common\models\Observation;
use common\models\Recommendation;
use common\components\Globals;
use common\helpers\Date;
use common\models\IssueStatusChanges;
use common\models\ReportingDetail;
use common\models\IssueReview;
use common\models\AuditCommittee;
use common\models\BoardDirective;
use common\models\PlanAssignment;

/**
 * PlanController implements the CRUD actions for Plan model.
 */
class PlanController extends Controller
{

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => \yii\filters\AccessControl::className(),
                'rules' => [
                    // allow authenticated users
                    [
                        'actions' => ['index'],
                        'allow' => true,
                        'roles' => ['accessCAGArea', 'accessIAGArea', 'accessOtherAudit', 'accessUploadReports'],
                    ],
                    [
                        'actions' => ['assign'],
                        'allow' => true,
                        'roles' => ['assignIssue'],
                    ],
                    [
                        'allow' => true,
                        'actions' => [
                            'assigned', 'enter', 'detailed-issues', 'cag', 'add', 'changedeadline', 'changestatus', 'create', 'delete', 'detailed-issues', 'edititem', 'reviews',
                            'startreport', 'statushistory', 'update', 'view', 'bulk-delete', 'setprevious'
                        ],
                        'roles' => ['@'],
                    ]
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                    'bulk-delete' => ['post'],
                ],
            ],
        ];
    }

    public function actionEnter($id)
    {
        return $this->render('index', [
            'model' => Source::find(['id' => $id]), 'source' => $id
        ]);
    }

    public function actionSetprevious()
    {
        echo "Updating ...<br/>";
        Plan::setPreviousIssues();
        echo "Done";
        exit;
    }

    public function actionCag()
    {
        return $this->render('cag', []);
    }

    /**
     * Lists all Plan models.
     * @return mixed
     */
    public function actionIndex($source, $active, $is_mine = 0, $other = null)
    {


        $votemodel = new VoteForm();
        $request = Yii::$app->request;

        if ($active == 4)
            $searchModel = new IagReportSearch;
        else
            $searchModel = new PlanSearch();

        $dataProvider = $searchModel->search(Yii::$app->request->queryParams, $source, $active, $other, $is_mine);
        return $this->render('index', [
            'source' => $source, 'active' => $active, 'id' => $votemodel->id, 'votemodel' => $votemodel,
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider, 'other' => $other
        ]);
    }

    public function actionDetailedIssues($status, $title, $previous = 0)
    {
        $searchModel = new PlanSearch();

        $dataProvider = $searchModel->searchReport(Yii::$app->request->queryParams, $previous);
        return $this->render('detailed-issues', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider, 'title' => $title
        ]);
    }

    public function actionReviews($active = 1)
    {
        $request = Yii::$app->request;
        $searchModel = new IssueReviewSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams, $active);


        return $this->render('reviews', [
            'active' => $active,
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionAdd($id, $active)
    {
        switch ($active) {
            case 0:
                $model = new Observation();

                break;
            case 1:
                $model = new Recommendation();

                break;
            case 2:
                $model = new AuditComment();

                break;
            case 3:

                $model = new ManagementResponse();
                break;
            case 4:
                $model = new RemedialAction();

                break;
            case 5:
                $model = new ActionTaken();

                break;
            case 6:
                $model = new IssueReview();

                break;
            case 7:
                $model = new AuditCommittee();

                break;
            case 8:
                $model = new BoardDirective();

                break;
        }

        $modelplan = $this->findModel($id);
        $model->plan_id = $modelplan->id;
        if ($active == 6)
            $model->vote_id = $modelplan->vote_id;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            //update review details
            if ($active == 6) :
                $modelplan->last_reviewed_at = time();
                $modelplan->last_reviewed_by = Yii::$app->user->id;
                //get vote update last reviewed
                $vote = $modelplan->vote;
                $vote->last_reviewed_at = time();
                $vote->last_reviewed_by = Yii::$app->user->id;
                $vote->update(false);
                $modelplan->update(false);
            //send  notifications
            elseif ($active == 5) :
                $modelplan->status = Plan::STATUS_INPROGRESS_VALUE;
                $modelplan->save(false);
            endif;
           return "reload_page";
            
            // return $this->redirect(['view', 'id' => (string) $model->_id]);
        } elseif (Yii::$app->request->isAjax) {
            return $this->renderAjax('_content', [
                'model' => $model, 'active' => $active, 'id' => $id
            ]);
        } else {
            return $this->render('_content', [
                'model' => $model, 'active' => $active, 'id' => $id
            ]);
        }
    }

    public function actionEdititem($id, $active)
    {
        switch ($active) {
            case 0:
                $model = Observation::findOne($id);

                break;
            case 1:
                $model = Recommendation::findOne($id);

                break;
            case 2:
                $model = AuditComment::findOne($id);

                break;
            case 3:

                $model = ManagementResponse::findOne($id);
                break;
            case 4:
                $model = RemedialAction::findOne($id);

                break;
            case 5:
                $model = ActionTaken::findOne($id);

                break;
            case 6:
                $model = IssueReview::findOne($id);

                break;
        }
        if ($model->load(Yii::$app->request->post()) && $model->update(false)) {
            if ($active == 6) :
                $vote = $model->vote;
                $vote->last_reviewed_at = time();
                $vote->last_reviewed_by = Yii::$app->user->id;
                $vote->update(false);
            endif;
            return "reload_page";
            // return $this->redirect(['view', 'id' => (string) $model->_id]);
        } elseif (Yii::$app->request->isAjax) {
            return $this->renderAjax('_updatecontent', [
                'model' => $model, 'active' => $active, 'id' => $id
            ]);
        } else {
            return $this->render('_updatecontent', [
                'model' => $model, 'active' => $active, 'id' => $id
            ]);
        }
    }

    public function actionStatushistory($id)
    {

        $model = $this->findModel($id);
        $items = IssueStatusChanges::find()
            ->where(['plan_id' => $model->id])
            ->all();
        if (Yii::$app->request->isAjax) {
            return $this->renderAjax('_statushistory', [
                'model' => $model, 'id' => $id, 'items' => $items
            ]);
        } else {
            return $this->render('_statushistory', [
                'model' => $model, 'id' => $id, 'items' => $items
            ]);
        }
    }

    public function actionStartreport($source, $active)
    {

        $model = new ReportingDetail();
        $financial_year = Globals::currentYear();
        $quarter = Globals::currentQuarter();
        $vote = Globals::myVote();
        $model->source_id = $source;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            //push current implemented as previous
            Plan::updateToPrevious($source, $vote->id);
            return $this->redirect(['index', 'source' => $source, 'active' => $active]);
            // return $this->redirect(['view', 'id' => (string) $model->_id]);
        } elseif (Yii::$app->request->isAjax) {
            return $this->renderAjax('_startreporting', [
                'model' => $model, 'source' => $source, 'financial_year' => $financial_year,
                'quarter' => $quarter, 'vote' => $vote, 'active' => $active
            ]);
        } else {
            return $this->render('_startreporting', [
                'model' => $model, 'source' => $source, 'financial_year' => $financial_year,
                'quarter' => $quarter, 'vote' => $vote, 'active' => $active
            ]);
        }
    }

    public function actionChangedeadline($id)
    {

        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {

            $model->timeline = Date::toTimestamp($model->deadline);
            $term = Plan::findTermLength($model->timeline);
            $model->length_term = $term;
            if ($model->save(false))
                return "reload_page";
            // return $this->redirect(['view', 'id' => (string) $model->_id]);
        } elseif (Yii::$app->request->isAjax) {
            return $this->renderAjax('_changedeadline', [
                'model' => $model, 'id' => $id
            ]);
        } else {
            return $this->render('_changedeadline', [
                'model' => $model, 'id' => $id
            ]);
        }
    }

    public function actionChangestatus($id)
    {

        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            if ($model->status == Plan::STATUS_IMPLEMENTED_VALUE) {
                $error = 0;
                if ($model->evidence) {
                    $model->evidence_implemented = $model->evidence;

                    if ($model->save(false)) {
                        //save changes logs 
                        $log = new IssueStatusChanges();
                        $log->plan_id = $model->id;
                        $log->status_to = $model->status;
                        $log->created_at = time();
                        $log->created_by = Yii::$app->user->id;
                        $log->remark = $model->evidence_implemented;
                        $log->save();
                        return $this->renderAjax('_status_success', [
                            'model' => $model
                        ]);
                    }
                } else {
                    $error = 1;
                }
                return $this->renderAjax('_status', [
                    'model' => $model, 'id' => $id, 'choosen' => 1, 'error' => $error
                ]);
            }
            if ($model->save(false))
                //save changes logs 
                $log = new IssueStatusChanges();
            $log->plan_id = $model->id;
            $log->status_to = $model->status;
            $log->created_at = time();
            $log->created_by = Yii::$app->user->id;
            $log->save();
            return "reload_page";
            // return $this->redirect(['view', 'id' => (string) $model->_id]);
        } elseif (Yii::$app->request->isAjax) {
            return $this->renderAjax('_status', [
                'model' => $model, 'id' => $id
            ]);
        } else {
            return $this->render('_status', [
                'model' => $model, 'id' => $id
            ]);
        }
    }

    /**
     * Displays a single Plan model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id, $active = 0)
    {
        $model = $this->findModel($id);

        switch ($active) {
            case 0:
                $items = $model->observations;

                break;
            case 1:
                $items = $model->recommendations;

                break;
            case 2:
                $items = $model->auditComments;

                break;
            case 3:

                $items = $model->managementResponses;
                break;
            case 4:
                $items = $model->remedialActions;

                break;
            case 5:
                $items = $model->actionsTaken;

                break;
            case 6:
                $items = $model->issueReviews;

                break;

            case 7:
                $items = $model->auditCommittee;
                break;
            case 8:
                $items = $model->boardDirective;
                break;

            default:
                $items = null;
                break;
        }

        return $this->render('view', [
            'model' => $this->findModel($id), 'active' => $active, 'items' => $items,
        ]);
    }

    /**
     * Creates a new Plan model.
     * For ajax request will return json object
     * and for non-ajax request if creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($source_id)
    {
        $request = Yii::$app->request;
        $model = new Plan();

        //get reporting details 
        $reportingDetail = Globals::currentReportingDetail($source_id);
        if (!$reportingDetail) {
            echo "A problem exists, contact administrator";
            exit;
        }
        $model->reporting_detail_id = $reportingDetail->id;
        //$model->para_year =$reportingDetail->financial_year_id;
        $model->vote_id = $reportingDetail->vote_id;
        $sourceog = $reportingDetail->source_id;
        // $model->source_id = $sourceog;
        // if($reportingDetail->quarter_id)
        //$model->quarter_id = $reportingDetail->quarter_id;

        if ($request->isAjax) {
            /*
             *   Process for ajax request
             */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if ($request->isGet) {
                return [
                    'title' => "Add New Observation /Directive",
                    'content' => $this->renderAjax('create', [
                        'model' => $model, 'sourceog' => $sourceog
                    ]),
                    'footer' => Html::button('Close', ['class' => 'btn btn-default pull-left', 'data-dismiss' => "modal"]) .
                        Html::button('Save', ['class' => 'btn btn-primary', 'type' => "submit"])
                ];
            } else if ($model->load($request->post())) {
                //$model->source_id = ($model->source_id)?$model->source_id:$sourceog;
                if ($model->save())
                    return [
                        'title' => "Create new Observation /Directive",
                        'content' => '<h3><span class="text-success">Observation /Directive added Successfully! </span></h3>',
                        'footer' => Html::button('Close', ['class' => 'btn btn-default pull-left', 'data-dismiss' => "modal"]) .
                            Html::a('Observation /Directive Details', ['view', 'id' => $model->id], ['class' => 'btn btn-success']) .
                            Html::a('Add Observation /Directive', ['create', 'source_id' => $model->source_id], ['class' => 'btn btn-primary', 'role' => 'modal-remote'])
                    ];
                else
                    return [
                        'title' => "Add New Observation /Directive",
                        'content' => $this->renderAjax('create', [
                            'model' => $model, 'sourceog' => $sourceog
                        ]),
                        'footer' => Html::button('Close', ['class' => 'btn btn-default pull-left', 'data-dismiss' => "modal"]) .
                            Html::button('Save', ['class' => 'btn btn-primary', 'type' => "submit"])
                    ];
            } else {

                return [
                    'title' => "Add New Observation /Directive",
                    'content' => $this->renderAjax('create', [
                        'model' => $model, 'sourceog' => $sourceog
                    ]),
                    'footer' => Html::button('Close', ['class' => 'btn btn-default pull-left', 'data-dismiss' => "modal"]) .
                        Html::button('Save', ['class' => 'btn btn-primary', 'type' => "submit"])
                ];
            }
        } else {
            /*
             *   Process for non-ajax request
             */
            if ($model->load($request->post())) {
                //  $model->source_id = ($model->source_id)?$model->source_id:$sourceog;
                if ($model->save())
                    return $this->redirect(['view', 'id' => $model->id]);
                else
                    return $this->render('create', [
                        'model' => $model, 'sourceog' => $sourceog
                    ]);
            } else {
                return $this->render('create', [
                    'model' => $model, 'sourceog' => $sourceog
                ]);
            }
        }
    }

    public function actionAssign($id)
    {

        $model = $this->findModel($id);
        $currentAssigned = $model->assigned_user_id;
        if ($model->load(Yii::$app->request->post()) && $model->save(false)) {
            if ($currentAssigned != $model->assigned_user_id) {
                $assignment = new PlanAssignment();
                $assignment->user_id = $model->assigned_user_id;
                $assignment->plan_id = $id;
                $assignment->created_at = time();
                $assignment->save();
            }
            return $this->redirect(Yii::$app->request->referrer);
        }
        return $this->renderAjax('_assign', [
            'model' => $model
        ]);
    }

    /**
     * Updates an existing Plan model.
     * For ajax request will return json object
     * and for non-ajax request if update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $request = Yii::$app->request;
        $model = $this->findModel($id);

        if ($request->isAjax) {
            /*
             *   Process for ajax request
             */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if ($request->isGet) {
                return [
                    'title' => "Update Plan #" . $id,
                    'content' => $this->renderAjax('update', [
                        'model' => $model,
                    ]),
                    'footer' => Html::button('Close', ['class' => 'btn btn-default pull-left', 'data-dismiss' => "modal"]) .
                        Html::button('Save', ['class' => 'btn btn-primary', 'type' => "submit"])
                ];
            } else if ($model->load($request->post()) && $model->save()) {
                return [
                    'forceReload' => '#crud-datatable-pjax',
                    'title' => "Plan #" . $id,
                    'content' => $this->renderAjax('view', [
                        'model' => $model,
                    ]),
                    'footer' => Html::button('Close', ['class' => 'btn btn-default pull-left', 'data-dismiss' => "modal"]) .
                        Html::a('Edit', ['update', 'id' => $id], ['class' => 'btn btn-primary', 'role' => 'modal-remote'])
                ];
            } else {
                return [
                    'title' => "Update Plan #" . $id,
                    'content' => $this->renderAjax('update', [
                        'model' => $model,
                    ]),
                    'footer' => Html::button('Close', ['class' => 'btn btn-default pull-left', 'data-dismiss' => "modal"]) .
                        Html::button('Save', ['class' => 'btn btn-primary', 'type' => "submit"])
                ];
            }
        } else {
            /*
             *   Process for non-ajax request
             */
            if ($model->load($request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('update', [
                    'model' => $model,
                ]);
            }
        }
    }

    /**
     * Delete an existing Plan model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $request = Yii::$app->request;
        $this->findModel($id)->delete();

        if ($request->isAjax) {
            /*
             *   Process for ajax request
             */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose' => true, 'forceReload' => '#crud-datatable-pjax'];
        } else {
            /*
             *   Process for non-ajax request
             */
            return $this->redirect(['index']);
        }
    }

    /**
     * Delete multiple existing Plan model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionBulkDelete()
    {
        $request = Yii::$app->request;
        $pks = explode(',', $request->post('pks')); // Array or selected records primary keys
        foreach ($pks as $pk) {
            $model = $this->findModel($pk);
            $model->delete();
        }

        if ($request->isAjax) {
            /*
             *   Process for ajax request
             */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose' => true, 'forceReload' => '#crud-datatable-pjax'];
        } else {
            /*
             *   Process for non-ajax request
             */
            return $this->redirect(['index']);
        }
    }

    /**
     * Finds the Plan model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Plan the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Plan::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
