<?php

namespace frontend\models;

use Yii;
use yii\base\Model;

/**
 * ContactForm is the model behind the contact form.
 */
class DashboardReportForm extends Model
{
    
   
    
    /** for reports **/
    public $report_type;
    public $report_financial_year_id;
    public $report_quarter_id;
    public $submitted;


    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            // name, email, subject and body are required
            [['report_type',
               'report_financial_year_id', 'report_quarter_id','submitted'
                ], 'integer'],
           

        ];
    }

    /**
     * @return array customized attribute labels
     */
    public function attributeLabels()
    {
        return [
            
            'report_type'=>Yii::t('frontend', 'Report Type'),
            'report_financial_year_id'=>Yii::t('frontend', 'Year'),
            'report_quarter_id'=>Yii::t('frontend', 'Quarter'),
            'submitted'=>Yii::t('frontend', 'Status'),
           
        ];
    }

}
