<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use common\models\VoteReport;

/**
 * ContactForm is the model behind the contact form.
 */
class ReportCommentForm extends Model {
   public $id;
   public $status;
   public $content;
           
    /**
     * @return array the validation rules.
     */
    public function rules() {
        return [
            // name, email, subject and body are required

            [['status','id','content'], 'required'],
             ['content', 'validateStatus'],
        ];
    }
   public function validateStatus($attribute, $params, $validator)
    {
         if($this->status == VoteReport::TYPE_REJECTED && empty($this->content))
          $this->addError($attribute, 'You must enter Reason for rejection');
        
    }
    /**
     * @return array customized attribute labels
     */
    public function attributeLabels() {
        return [
            'content' => Yii::t('frontend', 'Remarks'),
            'status' => Yii::t('frontend', 'Approve or Reject'),
        ];
    }

}
