<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use common\models\ReportingDetail;

/**
 * ContactForm is the model behind the contact form.
 */
class ReportFormVote extends Model
{
    
    public  $file;
    public  $vote_id;
    public  $financial_year_id;
    public  $quarter_id; 
    public  $description;
    public  $type;
    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            // name, email, subject and body are required
             [['file', 'type','financial_year_id', 'vote_id'], 'required'],
             [['file','type','description','financial_year_id','vote_id'], 'safe'],
            [['file'], 'file', 'extensions'=>'pdf, doc, docx,xlsx'],
            [['quarter_id'], 'validateQuarter'],
           

        ];
    }
           public function validateQuarter($attribute, $params, $validator)
    {
         if($this->quarter_id=="" && (ReportingDetail::IAG_QR_CODE==$this->type))
         $this->addError($attribute, 'You must choose Year and Quarter!');
    }

    /**
     * @return array customized attribute labels
     */
    public function attributeLabels()
    {
        return [
            
            'file' => Yii::t('frontend', 'File to Upload'),
            'financial_year_id' => Yii::t('frontend', 'Financial Year'),
            'description' => Yii::t('frontend', 'File Description'),
            'vote_id' => Yii::t('frontend', 'Vote'),
            'quarter_id'=>Yii::t('frontend', 'Quarter'),
            'type'=>Yii::t('frontend', 'Type of Report'),
            
           
           
        ];
    }

}
