<?php

namespace frontend\models;

use Yii;
use yii\base\Model;


/**
 * ContactForm is the model behind the contact form.
 */
class ReviewFeedbackForm extends Model
{
    
    public  $file;
   
    public  $financial_year_id;
    public  $description;
    public $published;
    public $vote_id;
    public $quarter_id;
   
    /**
     * @return array the validation rules.
     */
    public function rules()
    {
        return [
            // name, email, subject and body are required
             [['file','financial_year_id','vote_id','published'], 'required'],
             [['file','description','financial_year_id','vote_id','quarter_id'], 'safe'],
            [['file'], 'file', 'extensions'=>'pdf, doc, docx,xlsx'],
         
           

        ];
    }
     

    /**
     * @return array customized attribute labels
     */
    public function attributeLabels()
    {
        return [
            
            'file' => Yii::t('frontend', 'Review Document'),
            'vote_id' => Yii::t('frontend', 'Vote'),
            'financial_year_id'=>Yii::t('frontend', 'Financial Year'),
            'quarter_id'=>Yii::t('frontend', 'Quarter ( Optional )'),
            'description' => Yii::t('frontend', 'Review Description'),
            'published' => Yii::t('frontend', 'Publish'),
           
           
        ];
    }

}
