<?php

use yii\helpers\Url;
use common\components\Globals;
use kartik\select2\Select2;
use kartik\grid\GridView;
use common\models\Auditor;
use yii\helpers\Html;

return [
    [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
    [
        'class' => '\kartik\grid\DataColumn',
        'header' => 'Name',
        'attribute' => 'fullname',
    ],
    [
        'class' => '\kartik\grid\DataColumn',
        'attribute' => 'vote_id',
        'format' => 'raw',
        'filter' => \yii\helpers\ArrayHelper::map(Globals::allVotes(), 'id', 'name'),
        'filterType' => GridView::FILTER_SELECT2,
        'filterInputOptions' => ['placeholder' => ' -- Select --'],
        'filterWidgetOptions' => [
            'pluginOptions' => ['allowClear' => true],
        ],
        'value' => function($model) {
            return $model->vote ? $model->vote->name : "-";
        },
    ],
    [
        'class' => '\kartik\grid\DataColumn',
        'header' => 'Education Quali',
        'attribute' => 'highest_qualification',
    ],
    [
        'class' => '\kartik\grid\DataColumn',
        'header' => 'Professional Quali',
        'attribute' => 'professional',
        'value' => function($model) {
            return implode(',', $model->professional);
        }
    ],
    [
        'class' => '\kartik\grid\DataColumn',
        'header' => 'Position',
        'attribute' => 'title_position',
    ],
    [
        'class' => 'kartik\grid\ActionColumn',
        'visibleButtons' => [
            'view' => Globals::can('viewMoreDetailAuditor'),
            'delete' => Globals::can('removeAuditor'), // && $data->id,
            'update' => function($model) {
                return Globals::isMyVote($model->vote_id) || Globals::can('administrator');
            },
        //'update'=>Globals::can('updateAuditor') || 
        //  (Globals::can('updateOwnAuditor')),
        //$data->vote_id==Globals::myVote()->id
        ],
        'dropdown' => false,
        'vAlign' => 'middle',
        'urlCreator' => function($action, $model, $key, $index) {
            return Url::to([$action, 'id' => $key]);
        },
        'viewOptions' => ['role' => 'modal-remote', 'title' => 'View', 'data-toggle' => 'tooltip'],
        'updateOptions' => ['role' => 'modal-remote', 'title' => 'Update', 'data-toggle' => 'tooltip'],
        'deleteOptions' => ['role' => 'modal-remote', 'title' => 'Delete',
            'data-confirm' => false, 'data-method' => false, // for overide yii data api
            'data-request-method' => 'post',
            'data-toggle' => 'tooltip',
            'data-confirm-title' => 'Are you sure?',
            'data-confirm-message' => 'Are you sure want to delete this item'],
    ],
];
