<?php
use yii\helpers\Url;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use kartik\grid\GridView;
use johnitvn\ajaxcrud\CrudAsset; 
use johnitvn\ajaxcrud\BulkButtonWidget;
use common\components\Globals;

/* @var $this yii\web\View */
/* @var $searchModel common\models\search\Auditor */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Internal Auditors';
CrudAsset::register($this);

?>
<div class="auditor-index">
    <div id="ajaxCrudDatatable">
        <?=GridView::widget([
            'id'=>'crud-datatable',
            'dataProvider' => $dataProvider,
            'filterModel' => $searchModel,
            'pjax'=>true,
            'columns' => require(__DIR__.'/_columns.php'),
            'exportConfig' => [
            GridView::PDF => [
                'label' => 'PDF',
                'filename' => 'Preceptors',
                'title' => 'Preceptors',                        
                'options' => ['title' => 'Preceptor List','author' => 'Me'], 
                'showCaption' => false,
            ],
            GridView::CSV => [
                'label' => 'CSV',
                'filename' => 'Preceptors',
                'options' => ['title' => 'Preceptor List'],                                             
            ],
        

            ],
            'toolbar'=> [
                ['content'=>
                  Globals::can('addAuditor')? Html::a('<i class="glyphicon glyphicon-plus"></i> Add', ['create'],
                    ['role'=>'modal-remote','title'=> 'Add Auditor','class'=>'btn btn-success']):""
                    
                ],
                ['content'=>
                  Globals::can('printAuditors')?'{toggleData}'.
                    '{export}':""
                ],
            ],          
            'striped' => true,
            'condensed' => true,
            'responsive' => true,          
            'panel' => [
                'type' => 'primary', 
                'heading' => '<i class="glyphicon glyphicon-list"></i> Internal Auditors Database',
                'before'=>'<em>* Resize table columns just like a spreadsheet by dragging the column edges.</em>',
              
            ]
        ])?>
    </div>
</div>
<?php Modal::begin([
    "id"=>"ajaxCrudModal",
    "footer"=>"",// always need it for jquery plugin
])?>
<?php Modal::end(); ?>
