<?php

use yii\widgets\DetailView;
use common\components\Globals;
use common\models\User;

/* @var $this yii\web\View */
/* @var $model common\models\Auditor */
?>
<div class="auditor-view">

    <?=
    DetailView::widget([
        'model' => $model,
        'attributes' => [
            'first_name',
            'middle_name',
            'last_name',
            [
                'label' => 'Gender',
                'value' => $model->genderName,
            ],
            'title_position',
            'phone_number',
            'email:email',
            [
                'label' => 'Vote',
                'value' => $model->user ? $model->user->votesvalue : "",
            ],
            ['label' => 'Experience',
                'value' => Globals::get_age($model->date_of_appointment) . " Year(s)",
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
            ],
            ['label' => 'Check No#',
                'value' => $model->check_no,
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
            ]
            ,
            ['label' => 'Date of Appointment',
                'value' => $model->date_of_appointment ? date('d-M-Y', $model->date_of_appointment) : "-",
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
            ],
            ['label' => 'Highest Qualification',
                'value' => $model->highest_qualification ? \common\models\Options::qualifications()[$model->highest_qualification]:'',
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
            ],
            ['label' => 'Professional Qualification',
                'value' => implode(', ', $model->professional),
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
            ],
            
            ['label' => 'Title/postion',
                'value' => $model->title_position,
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
            ],
            ['label' => 'Employment/Transfer Letter',
                'value' => function($model) {
                    $link = $model->letterLink ? \yii\helpers\Html::a("download", $model->letterLink, ['target' => '_blank']) : NULL;
                    $uploadLink = \yii\helpers\Html::a("Add New", ["upload", "id" => $model->id, "type" => "letter"]);
                    return implode(" | ", [$link, $uploadLink]);
                },
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
                'format' => 'raw'
            ],
            ['label' => 'CV',
                'value' => function($model) {
                    $link = $model->cvLink ? \yii\helpers\Html::a("download", $model->cvLink, ['target' => '_blank']) : NULL;
                    $uploadLink = \yii\helpers\Html::a("Add New", ["upload", "id" => $model->id, "type" => "cv"]);
                    return implode(" | ", [$link, $uploadLink]);
                },
                'visible' => Globals::isMyVote($model->vote_id) || !User::isIAOfficer(),
                'format' => 'raw'
            ]
        ],
    ])
    ?>

</div>
