<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\components\Globals;
use common\models\Vote;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use common\models\Auditor;
use common\helpers\Date;
use kartik\date\DatePicker;

/* @var $this yii\web\View */
/* @var $model common\models\Auditor */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="auditor-form">

    <?php $form = ActiveForm::begin(); ?>


    <div class="row">
        <div class="col-md-6">

            <?= $form->field($model, 'first_name')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($model, 'middle_name')->textInput(['maxlength' => true]) ?>
        </div>

    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'last_name')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-6">
            <?php
            $genders = Auditor::genderoptions();
            $listData = ArrayHelper::map($genders, 'id', 'name');
            echo $form->field($model, 'gender')->widget(Select2::classname(), [
                'data' => $listData,
                'language' => 'en',
                'options' => ['placeholder' => 'Select ...', 'id' => 'genderid'],
                'pluginOptions' => [
                    'allowClear' => true,
                    'dropdownParent' => new yii\web\JsExpression('$("#ajaxCrudModal")'), 
                ],
            ]);
            ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'phone_number')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
        </div>

    </div>
    <div class="row">
        <div class="col-md-6">
            <?=
            $form->field($model, 'highest_qualification')->widget(Select2::classname(), [
                'data' => \common\models\Options::qualifications(),
                'language' => 'en',
                'options' => ['placeholder' => 'Select ...', 'id' => 'qualifications'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]);
            ?>
        </div>
      <div class="col-md-6">
            <?= $form->field($model, 'professional')->textInput(['maxlength' => true, 'placeholder' => "Accountant, Economist..."]) ?>
        </div>
    </div>
    <div class="row text-center"> <h5>Appointment</h5></div>
    <div class="row">
        <div class="col-md-6">
            <?php
            echo $form->field($model, 'member_type')->dropdownList(\common\models\Options::cometteeMemberTypes(), ['prompt' => 'Select ...', 'id' => 'member_type']
            );
            ?>
        </div>
        <div class="col-md-6">
            <?php
            $votes = Globals::allVotes();
            $listData = ArrayHelper::map($votes, 'id', 'name');
            echo $form->field($model, 'vote_id')->widget(Select2::classname(), [
                'data' => $listData,
                'language' => 'en',
                'options' => ['placeholder' => 'Select ...', 'id' => 'voteid'],
                'pluginOptions' => [
                    'allowClear' => true,
                    'dropdownParent' => new yii\web\JsExpression('$("#ajaxCrudModal")'), 
                ],
            ]);
            ?>
        </div>

    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'title_position')->dropDownList(\common\models\Options::cometteeMemberPositionTypes()) ?>
        </div>

        <div class="col-md-6">
            <div>
                <label class="control-label" for="committeemember-email">Appointment Date</label>
            </div>
            <div class="col-md-6" style="padding:0px !important">
                <?=
                DatePicker::widget([
                    'model' => $model,
                    'type' => DatePicker::TYPE_INPUT,
                    'attribute' => 'appointmentStartDate',
                    'options' => ['placeholder' => 'Start'],
                    'pluginOptions' => [
                        'format' => 'dd-M-yyyy',
                        'todayHighlight' => true,
                        'autoclose' => true,
                    ]
                ]);
                ?>
            </div>
            <div class="col-md-6" style="padding:0px !important">
                <?=
                DatePicker::widget([
                    'model' => $model,
                    'type' => DatePicker::TYPE_INPUT,
                    'attribute' => 'appointmentEndDate',
                    'options' => ['placeholder' => 'End'],
                    'pluginOptions' => [
                        'format' => 'dd-M-yyyy',
                        'todayHighlight' => true,
                        'autoclose' => true,
                    ]
                ]);
                ?>
            </div>
        </div>
    </div>
   
    <?php if (!Yii::$app->request->isAjax) { ?>
        <div class="form-group">
            <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        </div>
    <?php } ?>

    <?php ActiveForm::end(); ?>

</div>
