<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use kartik\switchinput\SwitchInput;
/* @var $this yii\web\View */
/* @var $model common\models\FinancialYear */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="financial-year-form">

    <?php $form = ActiveForm::begin(); ?>
    <?= $form->errorSummary($model); ?>
<?= $form->field($model, 'code')->textInput() ?>
  <label class="control-label">Start date</label>
    <?= DatePicker::widget([
	'model' => $model,
          'attribute' => 'initial_date', 	
	'options' => ['placeholder' => 'Select start date'],
	'pluginOptions' => [
		'format' => 'dd-M-yyyy',
		'todayHighlight' => true
	]
]); ?>
   <label class="control-label">End Date</label>
      <?= DatePicker::widget([
	'model' => $model,
          'attribute' => 'final_date',  	
	'options' => ['placeholder' => 'Select end date'],
	'pluginOptions' => [
		'format' => 'dd-M-yyyy',
		'todayHighlight' => true
	]
]); ?>
   
  <?= $form->field($model, 'is_current')->widget(SwitchInput::classname(), [
    'type' => SwitchInput::CHECKBOX
]);?>
    
    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
