<?php
use yii\helpers\Url;
use common\models\search\Category;
use common\models\Vote;
use common\models\FinancialYear;
use common\models\Plan;
use yii\helpers\Html; 
use common\models\User;
use kartik\select2\Select2;
use kartik\grid\GridView;
use common\components\Globals;

return [
    [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
  
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'vote_id',
         'format' => 'raw',
          'visible'=>!User::isIAOfficer(),
        'filter' => \yii\helpers\ArrayHelper::map(Globals::allVotes(), 'id', 'name'),
           'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- Select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->vote?$model->vote->name:"-";
         },
    ],
        // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'id',
    // ],
   
    
   
   
    [
         'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'item_no',
     ],
     [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'para_year',
         'format' => 'raw',
        'filter' => \yii\helpers\ArrayHelper::map(FinancialYear::all(), 'id', 'code'),
            'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- Select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->paraYear?$model->paraYear->code:"-";
         },
    ],
    
     [
         'class'=>'\kartik\grid\DataColumn',
         'attribute'=>'title',
     ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'category_id',
         'format' => 'raw',
        'filter' => \yii\helpers\ArrayHelper::map(Category::all(), 'id', 'name'),
           'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- Select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->category?$model->category->name:"-";
         },
    ],
                 
    
                  [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = !$model->observations?"<i class='fa fa-plus'></i>":"";
                      $linkUrl = ['/plan/view','id'=>$model->id];                 
                      $result=Html::a("$icon Details",$linkUrl,array('title'=>'View Details', ));
                      
                     return $result;
                     
                     
                     },
     ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'timeline',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'responsible_personal',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'status',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'reporting_detail_id',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'current_previous',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'length_term',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'created_at',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'created_by',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'updated_at',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'updated_by',
    // ],
   

];   