<?php
use yii\helpers\Url;
use common\models\search\Category;
use common\models\Vote;
use common\models\FinancialYear;
use yii\helpers\Html; 
use common\models\User;
use common\components\Globals;
use common\models\ReportingDetail;
use kartik\select2\Select2;
use kartik\grid\GridView;
use common\models\Quarter;
use common\helpers\Date;
use common\models\VoteReport;
return [
          
   [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'type',
         'format' => 'raw',
         'filter'=>\yii\helpers\ArrayHelper::map(ReportingDetail ::iagReportOptions(), 'id', 'name'),          
          'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
       'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return ReportingDetail::iagReportType($model->type);
         },
    ],
  [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'vote_id',
         'format' => 'raw',
          'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'visible'=>!User::isIAOfficer(),
        'filter' => \yii\helpers\ArrayHelper::map(Globals::myVotes(), 'id', 'name'),
      
        'value' => function($model) {
                    return $model->vote?$model->vote->name:"-";
         },
    ],
    
      
     [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'financial_year_id',
         'format' => 'raw',
        'filter' => \yii\helpers\ArrayHelper::map(FinancialYear::all(), 'id', 'code'),
            'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->financialYear?$model->financialYear->code:"-";
         },
    ],
                               [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
        
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-paperclip'></i>";
                      if($model->quarter_id)
                      $quarter =  Quarter::findOne($model->quarter_id);
                      
                     return isset($quarter)?"Quarter: ".$quarter->code:"";
                     
                     
                     },
     ],
                       [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-download'></i>";
                      $linkUrl = $model->filepath;  
    
                      $result=Html::a("$icon Download",Url::to(['/report-detail/downloadiag','file'=>$linkUrl]),['title'=>'Download','target'=>'_blank']);
                      $date="<br/>added: <i class='small'>".Date::toDateString ($model->created_at)."</i>";
                     /** $viewlinkUrl = Url::to(['report-detail/commentview', 'id'=>$model->id]);
                      $view=Html::a('View','#',['title'=>'View Details and Remarks',
                          'data-title'=>'Remarks on this report','class'=>'showModal btn-small'
                          ,'data-url'=>$viewlinkUrl]);
                      $view = $model->approved?$view:""; **/
                      return $result." ".$date; //." ".$model->approvedvalue." ".$view;
                     
                     
                     },
     ],
                        /***                                   [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-comment'></i>";
                      $linkUrl = Url::to(['report-detail/comment', 'id'=>$model->id]);
                       $visible = Globals::inMyVote($model->vote) && !User::isIAOfficer() && ($model->approved != VoteReport::TYPE_ACCEPTED);
                      $result=Html::a($icon.'approve?','#',['title'=>'Approve or Reject with Comments',
                          'data-title'=>'Approve or Reject Report','class'=>'showModal btn-small'
                          ,'data-url'=>$linkUrl]);
                      
                     return $visible?$result:"";
                     
                     
                     },
     ],    ***/                                                  
                                     [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-trash'></i>";
                      $linkUrl = $model->filepath;  
                       $visible = Globals::can('removereport');
                      $result=Html::a("$icon",Url::to(['/report-detail/delete','id'=>$model->id]),['title'=>'Remove and re-upload report','onClick' =>'return confirm("Are you sure? remove this report!")']);
                      
                     return $visible?$result:"";
                     
                     
                     },
     ],
                             
                                  [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'Uploaded',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                    
                     return User::getFullname($model->user->id);
                     
                     
                     },
     ],
   
       /**           [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = !$model->observations?"<i class='fa fa-plus'></i>":"";
                      $linkUrl = ['/plan/view','id'=>$model->id];                 
                      $result=Html::a("$icon Details",$linkUrl,array('title'=>'View Details', ));
                      
                     return $result;
                     
                     
                     },
     ], ****/
   
   

];   