<?php
use yii\helpers\Url;
use common\models\search\Category;
use common\models\Vote;
use common\models\FinancialYear;
use common\models\Plan;
use yii\helpers\Html; 
use common\models\User;
use common\components\Globals;

return [
    [
        'class' => 'kartik\grid\CheckboxColumn',
        'width' => '20px',
    ],
  
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'vote_id',
         'format' => 'raw',
          'visible'=>!User::isIAOfficer(),
        'filter' => \yii\helpers\ArrayHelper::map(Vote::getItems(), 'id', 'name'),
        'value' => function($model) {
                    return $model->vote?$model->vote->name:"-";
         },
    ],
      
         /***         [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                     
                      $linkUrl = ['/plan/view','id'=>$model->id];                 
                      $result=Html::a("Assigned To",$linkUrl,array('title'=>'View Details', ));
                      
                     return $result;
                     
                     
                     },
     ],
          * ***/
         
                                      [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'Last Reviewed On',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                     
                     return date('d-M-Y',$model->created_at);
                     
                     
                     },
     ],
                                      [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'Reviewed By',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                     
                     return User::getFullname($model->created_by);
                     
                     
                     },
     ],
                                    [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-eye'></i>";
                      $linkUrl = ['/plan/view','id'=>$model->plan_id,'active'=>6];                 
                      $result=Html::a("$icon Details",$linkUrl,array('title'=>'View Review Details', ));
                      
                     return $result;
                     
                     
                     },
     ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'timeline',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'responsible_personal',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'status',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'reporting_detail_id',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'current_previous',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'length_term',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'created_at',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'created_by',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'updated_at',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'updated_by',
    // ],
   

];   