<?php
use yii\helpers\Url;
use common\models\FinancialYear;
use yii\helpers\Html; 
use common\models\User;
use common\components\Globals;
use common\models\ReportingDetail;
use kartik\select2\Select2;
use kartik\grid\GridView;
use common\models\Quarter;

return [
    [
        'class' => 'kartik\grid\CheckboxColumn',
        'width' => '20px',
    ],
    [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
        // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'id',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'created_at',
    // ],
   
    
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'report_type',
         'format' => 'raw',
         'filter'=>\yii\helpers\ArrayHelper::map(ReportingDetail ::iagReportOptions(), 'id', 'name'),          
          'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
       'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return ReportingDetail::iagReportType($model->report_type);
         },
    ],
     [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'initial_date',
    ],
                  [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'final_date',
    ],
                  [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'due_date_deadline',
    ],
     [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'financial_year_id',
         'format' => 'raw',
        'filter' => \yii\helpers\ArrayHelper::map(FinancialYear::all(), 'id', 'code'),
            'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->financialYear?$model->financialYear->code:"-";
         },
    ],
                         [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
        
        'value'=>
                     function($model) {
                     
                      if($model->quarter_id)
                      $quarter =  Quarter::findOne($model->quarter_id);
                      
                     return isset($quarter)?"Quarter: ".$quarter->code:"";
                     
                     
                     },
     ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'publish_start',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'publish_end',
    // ],
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'is_due',
    // ],
    [
        'class' => 'kartik\grid\ActionColumn',
        'dropdown' => false,
        'vAlign'=>'middle',
        'urlCreator' => function($action, $model, $key, $index) { 
                return Url::to([$action,'id'=>$key]);
        },
        'viewOptions'=>['role'=>'modal-remote','title'=>'View','data-toggle'=>'tooltip'],
        'updateOptions'=>['role'=>'modal-remote','title'=>'Update', 'data-toggle'=>'tooltip'],
        'deleteOptions'=>['role'=>'modal-remote','title'=>'Delete', 
                          'data-confirm'=>false, 'data-method'=>false,// for overide yii data api
                          'data-request-method'=>'post',
                          'data-toggle'=>'tooltip',
                          'data-confirm-title'=>'Are you sure?',
                          'data-confirm-message'=>'Are you sure want to delete this item'], 
    ],

];   