<?php
use yii\helpers\Url;
use common\models\search\Category;
use common\models\Vote;
use common\models\FinancialYear;
use yii\helpers\Html; 
use common\models\User;
use common\components\Globals;
use common\models\ReportingDetail;
use kartik\select2\Select2;
use kartik\grid\GridView;
use common\models\Quarter;
return [
    [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
   [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'type',
         'format' => 'raw',
         'filter'=>\yii\helpers\ArrayHelper::map(ReportingDetail ::iagReportOptions(), 'id', 'name'),          
          'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
       'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return ReportingDetail::iagReportType($model->type);
         },
    ],
  [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'vote_id',
         'format' => 'raw',
          'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
      
        'filter' => \yii\helpers\ArrayHelper::map(Globals::allVotes(), 'id', 'name'),
      
        'value' => function($model) {
                    return $model->vote?$model->vote->name:"-";
         },
    ],
    
      
     [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'financial_year_id',
         'format' => 'raw',
        'filter' => \yii\helpers\ArrayHelper::map(FinancialYear::all(), 'id', 'code'),
            'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->financialYear?$model->financialYear->code:"-";
         },
    ],
                               [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
        
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-paperclip'></i>";
                      if($model->quarter_id)
                      $quarter =  Quarter::findOne($model->quarter_id);
                      
                     return isset($quarter)?"Quarter: ".$quarter->code:"";
                     
                     
                     },
     ],
                       [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-download'></i>";
                      $linkUrl = $model->filepath;  
    
                      $result=Html::a("$icon Download",Url::to(['/report-detail/downloadiag','file'=>$linkUrl]),['title'=>'Download','target'=>'_blank']);
                      
                     return $result;
                     
                     
                     },
     ],
   
       /**           [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = !$model->observations?"<i class='fa fa-plus'></i>":"";
                      $linkUrl = ['/plan/view','id'=>$model->id];                 
                      $result=Html::a("$icon Details",$linkUrl,array('title'=>'View Details', ));
                      
                     return $result;
                     
                     
                     },
     ], ****/
   
   

];   