<?php
use yii\helpers\Url;
use yii\helpers\Html; 
use kartik\grid\GridView;
use common\helpers\Date;
use kartik\select2\Select2;
use common\models\User;
use common\components\Globals;
use common\models\FinancialYear;
use common\models\Quarter;
return [
  
    [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'vote_id',
         'format' => 'raw',
          'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        
        'filter' => \yii\helpers\ArrayHelper::map(Globals::myVotes(), 'id', 'name'),
      
        'value' => function($model) {
                    return $model->vote?$model->vote->name:"-";
         },
    ],
                  [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'financial_year_id',
         'format' => 'raw',
        'filter' => \yii\helpers\ArrayHelper::map(FinancialYear::all(), 'id', 'code'),
            'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->financialYear?$model->financialYear->code:"-";
         },
    ],
                               [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
        
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-paperclip'></i>";
                      if($model->quarter_id)
                      $quarter =  Quarter::findOne($model->quarter_id);
                      
                     return isset($quarter)?"Quarter: ".$quarter->code:"";
                     
                     
                     },
     ],
        // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'id',
    // ],
   
   
              [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-download'></i>";
                      $linkUrl = $model->filename;  
    
                      $result=Html::a("$icon Download",Url::to(['/review-feedback/download','file'=>$linkUrl]),['title'=>'Download','target'=>'_blank']);
                      
                     return $result;
                     
                     
                     },
     ],
  
    // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'created_at',
    // ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'header'=>'Created At',
      
        'visible'=>!User::isIAOfficer(),
        'value'=>
                     function($model) {
                    
                     return Date::toDateString ($model->created_at);
                     
                     
                     },
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'published',
        'visible'=>!User::isIAOfficer(),
         'filter'=>\yii\helpers\ArrayHelper::map([['id'=>'1','name'=>'Yes'],['id'=>0,'name'=>'No']], 'id', 'name'),          
          'filterType' => GridView::FILTER_SELECT2, 
        
        'value'=>
                     function($model) {
                    
                     return $model->published?"Yes":"NO";
                     
                     
                     },
    ],
       [
        'class'=>'\kartik\grid\DataColumn',
         'header'=>'',
          'format' => 'raw',
       'visible'=>!User::isIAOfficer(),
        'value'=>
                     function($model) {
                      $icon = "<i class='fa fa-pencil'></i>";
                      $linkUrl = $model->filename;  
    
                      $result=Html::a("$icon Edit",Url::to(['/review-feedback/updateupload','id'=>$model->id]),['title'=>'Edit']);
                      
                     return $result;
                     
                     
                     },
     ],

];   