<?php
use yii\helpers\Url;
use common\models\Vote;
use kartik\select2\Select2;
use kartik\grid\GridView;

return [
   
       [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'code',
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'name',
    ],
         [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'group_id',
         'format' => 'raw',
        'filter' => Vote::groups(),
           'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- Select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->group;
         },
    ],
                    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'directed_to_submit',
         'format' => 'raw',
        'filter' => Vote::submits(),
           'filterType' => GridView::FILTER_SELECT2, 
          'filterInputOptions' => ['placeholder' => ' -- Select --'],
      'filterWidgetOptions' => [
        'pluginOptions' => ['allowClear' => true],
    ],
        'value' => function($model) {
                    return $model->cansubmit;
         },
    ],
    [
        'class' => 'kartik\grid\ActionColumn',
        'dropdown' => false,
        'vAlign'=>'middle',
        'urlCreator' => function($action, $model, $key, $index) { 
                return Url::to([$action,'id'=>$key]);
        },
        'viewOptions'=>['role'=>'modal-remote','title'=>'View','data-toggle'=>'tooltip'],
        'updateOptions'=>['role'=>'modal-remote','title'=>'Update', 'data-toggle'=>'tooltip'],
         
    ],

];   