<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\models\Vote;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model common\models\Vote */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="vote-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'code')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>

      <?php
        
        $listData= Vote::groups();
       echo $form->field($model, 'group_id')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select ...', 'id'=>'cate_id'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);
        ?>
  <?php
        
        $listData= Vote::submits();
       echo $form->field($model, 'directed_to_submit')->widget(Select2::classname(), [
    'data' => $listData,
    'language' => 'en',
    'options' => ['placeholder' => 'Select ...', 'id'=>'directed_id'],
    'pluginOptions' => [
        'allowClear' => true
    ],
]);
        ?>
  
	<?php if (!Yii::$app->request->isAjax){ ?>
	  	<div class="form-group">
	        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
	    </div>
	<?php } ?>

    <?php ActiveForm::end(); ?>
    
</div>
